<?php
include "config.php";

if(!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin'){
    die("غير مصرح بالدخول");
}


$result = $conn->query("
    SELECT 
        a.agent_id,
        COALESCE(c.total_collected,0) AS total_collected,
        COALESCE(s.total_settled,0) AS total_settled,
        COALESCE(c.total_collected,0) - COALESCE(s.total_settled,0) AS balance
    FROM (
        SELECT DISTINCT agent_id FROM stores
    ) a
    LEFT JOIN (
        SELECT agent_id, SUM(amount) total_collected
        FROM agent_collections GROUP BY agent_id
    ) c ON c.agent_id = a.agent_id
    LEFT JOIN (
        SELECT agent_id, SUM(amount) total_settled
        FROM agent_settlements GROUP BY agent_id
    ) s ON s.agent_id = a.agent_id
");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تحصيل المندوبين</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php" class="btn btn-home">
            <span class="btn-icon">🏠</span>
            الرئيسية
        </a>
        <a href="admin_dashboard.php" class="btn btn-back">
            <span class="btn-icon">⬅</span>
            رجوع
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">تحصيل المندوبين</h2>
</div>

<div class="table-wrapper">
    <table>
        <thead>
            <tr>
                <th class="sortable">المندوب</th>
                <th class="sortable">مجموع القبض</th>
                <th class="sortable">مجموع التسليم</th>
                <th class="sortable">الرصيد</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><strong><?= htmlspecialchars($row['agent_id']) ?></strong></td>
                <td><?= number_format($row['total_collected'], 2) ?> $</td>
                <td><?= number_format($row['total_settled'], 2) ?> $</td>
                <td>
                    <span class="badge <?= $row['balance'] > 0 ? 'danger' : 'success' ?>">
                        <strong><?= number_format($row['balance'], 2) ?> $</strong>
                    </span>
                </td>
                <td>
                    <a href="agent_settlement.php?agent_id=<?= urlencode($row['agent_id']) ?>" 
                       class="btn btn-primary">
                        <span class="btn-icon">💰</span>
                        تسجيل تسليم
                    </a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script src="js/main.js"></script>
</body>
</html>