<?php
include "config.php";

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'agent') {
    die("غير مصرح بالدخول");
}

$agent_id = $_SESSION['agent_id'];

$tiers_data = include __DIR__ . '/tiers_prices.php';
$calculate_price = $tiers_data['calculate_price'];

/* ===============================
   الملخص المالي
================================ */
$q1 = $conn->prepare("SELECT COALESCE(SUM(amount),0) FROM agent_collections WHERE agent_id=?");
$q1->bind_param("s", $agent_id);
$q1->execute();
$q1->bind_result($total_collected);
$q1->fetch();
$q1->close();

$q2 = $conn->prepare("SELECT COALESCE(SUM(amount),0) FROM agent_settlements WHERE agent_id=?");
$q2->bind_param("s", $agent_id);
$q2->execute();
$q2->bind_result($total_settled);
$q2->fetch();
$q2->close();

$balance = round($total_collected - $total_settled, 2);

/* ===============================
   تحديث حالة الدفع
================================ */
$today = date('Y-m-d');
$conn->query("
    UPDATE stores 
    SET payment_status = CASE
        WHEN payment_due_date = DATE_ADD('$today', INTERVAL 2 DAY) THEN 'near_expiry_2'
        WHEN payment_due_date = DATE_ADD('$today', INTERVAL 7 DAY) THEN 'near_expiry_7'
        WHEN payment_due_date < '$today' THEN 'expired'
        ELSE payment_status
    END
");

/* ===============================
   الدفع
================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['store_id'])) {

    $store_id = (int)$_POST['store_id'];
    $subscription_type = $_POST['subscription_type'];
    $new_tier = $_POST['new_tier'];

    $payment_amount = $calculate_price($new_tier, $subscription_type);

    $payment_due_date =
        $subscription_type === 'monthly' ? date('Y-m-d', strtotime('+1 month')) :
        ($subscription_type === 'semi-annual' ? date('Y-m-d', strtotime('+6 months')) :
        date('Y-m-d', strtotime('+1 year')));

    try {
        $conn->begin_transaction();

        $stmt = $conn->prepare("
            UPDATE stores SET
                payment_status='paid',
                last_payment_amount=?,
                last_payment_date=NOW(),
                payment_due_date=?,
                subscription_type=?,
                tier=?
            WHERE id=? AND agent_id=?
        ");
        $stmt->bind_param(
            "dsssis",
            $payment_amount,
            $payment_due_date,
            $subscription_type,
            $new_tier,
            $store_id,
            $agent_id
        );
        $stmt->execute();

        $stmt2 = $conn->prepare("
            INSERT INTO agent_collections
            (agent_id, store_id, amount, tier, subscription_type)
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt2->bind_param(
            "sidss",
            $agent_id,
            $store_id,
            $payment_amount,
            $new_tier,
            $subscription_type
        );
        $stmt2->execute();

        $conn->commit();
        header("Location: ".$_SERVER['PHP_SELF']);
        exit;

    } catch (Exception $e) {
        $conn->rollback();
        die("خطأ أثناء الدفع: ".$e->getMessage());
    }
}

/* ===============================
   جلب المتاجر
================================ */
$stmt = $conn->prepare("SELECT * FROM stores WHERE agent_id=?");
$stmt->bind_param("s", $agent_id);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>لوحة المندوب</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>

<!-- Navbar -->
<div class="nav-bar">
    <div class="nav-links">
        <a href="agent_dashboard.php" class="btn btn-home">
            <span class="btn-icon">🏠</span> الرئيسية
        </a>
                <a href="agent_manage_users.php" class="btn btn-info">
            <span class="btn-icon">👥</span>
            إدارة المستخدمين
        </a>
        <a href="agents_financials.php" class="btn btn-success">
            <span class="btn-icon">💰</span> حسابي المالي
        </a>
        
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span> تسجيل الخروج
    </a>
</div>

<!-- Header -->
<div class="page-header">
    <h2 class="page-title">لوحة المندوب - متاجري</h2>
    <div class="agent-summary">
        💰 القبض: <b><?= $total_collected ?> $</b> |
        📤 المسلّم: <b><?= $total_settled ?> $</b> |
        📊 الرصيد:
        <b class="<?= $balance > 0 ? 'text-danger' : 'text-success' ?>">
            <?= $balance ?> $
        </b>
    </div>
</div>

<!-- Table -->
<div class="table-wrapper">

    <div class="table-controls">
        <div class="search-box">
            <input type="text" id="tableSearch" placeholder="🔍 ابحث عن متجر...">
        </div>

        <div class="filter-controls">
            <select class="filter-select" id="paymentFilter">
                <option value="all">جميع حالات الدفع</option>
                <option value="paid">مدفوع</option>
                <option value="expired">منتهي</option>
                <option value="near_expiry_7">قريب (7 أيام)</option>
                <option value="near_expiry_2">قريب جدًا (يومان)</option>
            </select>

            <select class="filter-select" id="storeFilter">
                <option value="all">جميع حالات المتجر</option>
                <option value="مفعل">مفعل</option>
                <option value="متوقف">متوقف</option>
            </select>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>الاسم</th>
                <th>المحافظة</th>
                <th>حالة المتجر</th>
                <th>حالة الدفع</th>
                <th>المستوى</th>
                <th>انتهاء الاشتراك</th>
                <th>آخر دفعة</th>
                <th>إدارة</th>
            </tr>
        </thead>
        <tbody>
        <?php while($store = $result->fetch_assoc()): ?>
            <tr>
                <td><?= $store['id'] ?></td>
                <td><?= htmlspecialchars($store['name']) ?></td>
                <td><?= htmlspecialchars($store['governorate']) ?></td>

                <td>
                    <span class="badge <?= $store['is_active'] ? 'active' : 'inactive' ?>">
                        <?= $store['is_active'] ? 'مفعل' : 'متوقف' ?>
                    </span>
                </td>

                <td>
                    <span class="badge <?= $store['payment_status'] ?>">
                        <?= $store['payment_status'] ?>
                    </span>
                </td>

                <td><?= $store['tier'] ?></td>
                <td><?= $store['payment_due_date'] ?></td>
                <td><?= number_format((float)($store['last_payment_amount'] ?? 0), 2) ?> $</td>

                <td>
                    <form method="post" class="payment-form">
                        <input type="hidden" name="store_id" value="<?= $store['id'] ?>">

                        <select name="subscription_type" class="subscription_type">
                            <option value="monthly">شهري</option>
                            <option value="semi-annual">نصف سنوي</option>
                            <option value="yearly">سنوي</option>
                        </select>

                        <select name="new_tier" class="new_tier">
                            <?php
                            foreach (['FREE','SILVER','GOLD','PLATINUM','DIMOUND','VIP'] as $tier) {
                                echo "<option value='$tier'>$tier</option>";
                            }
                            ?>
                        </select>

                        <p style="margin:6px 0;">المبلغ:
                            <span class="calculated_amount">0.00</span> $
                        </p>

                        <button type="submit" class="btn btn-primary">
                            💳 دفع
                        </button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script>
const tiers = <?= json_encode($tiers_data['tiers']) ?>;
const discounts = <?= json_encode($tiers_data['discounts']) ?>;

document.querySelectorAll('.payment-form').forEach(form => {
    const tier = form.querySelector('.new_tier');
    const type = form.querySelector('.subscription_type');
    const out  = form.querySelector('.calculated_amount');

    function calc(){
        let base = tiers[tier.value] || 0;
        let m = type.value === 'semi-annual' ? 6 : type.value === 'yearly' ? 12 : 1;
        let d = discounts[type.value] || 0;
        out.textContent = (base * m * (1 - d/100)).toFixed(2);
    }
    tier.onchange = type.onchange = calc;
    calc();
});

document.getElementById('tableSearch').addEventListener('keyup', function () {
    const v = this.value.toLowerCase();
    document.querySelectorAll('tbody tr').forEach(r=>{
        r.style.display = r.textContent.toLowerCase().includes(v) ? '' : 'none';
    });
});

const paymentFilter = document.getElementById('paymentFilter');
const storeFilter   = document.getElementById('storeFilter');

function applyFilters() {
    const pVal = paymentFilter.value;
    const sVal = storeFilter.value.toLowerCase();

    document.querySelectorAll('tbody tr').forEach(row => {
        const storeStatus   = row.children[3].textContent.trim().toLowerCase();
        const paymentStatus = row.children[4].textContent.trim();

        const matchPayment = pVal === 'all' || paymentStatus.includes(pVal);
        const matchStore   = sVal === 'all' || storeStatus === sVal;

        row.style.display = (matchPayment && matchStore) ? '' : 'none';
    });
}

paymentFilter.addEventListener('change', applyFilters);
storeFilter.addEventListener('change', applyFilters);
</script>

</body>
</html>
