
<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "config.php";

if(!isset($_SESSION['role']) || $_SESSION['role'] != 'admin'){
    die("غير مصرح بالدخول");
}

$roles = ['admin','agent','user','vendor'];
$user_counts = [];
$res = $conn->query("SHOW TABLES LIKE 'users'");
if($res && $res->num_rows > 0){
    foreach($roles as $role){
        $count_res = $conn->query("SELECT COUNT(*) as cnt FROM users WHERE role='$role'");
        $user_counts[$role] = $count_res ? $count_res->fetch_assoc()['cnt'] : 0;
    }
}

$store_counts = [];
$res = $conn->query("SHOW TABLES LIKE 'stores'");
if($res && $res->num_rows > 0){
    $store_res = $conn->query("SELECT tier, subscription_type, is_active, COUNT(*) as cnt 
                               FROM stores 
                               GROUP BY tier, subscription_type, is_active");
    while($row = $store_res->fetch_assoc()){
        $store_counts[] = $row;
    }
}

$product_count = 0;
$res = $conn->query("SHOW TABLES LIKE 'products'");
if($res && $res->num_rows > 0){
    $count_res = $conn->query("SELECT COUNT(*) as cnt FROM products");
    $product_count = $count_res ? $count_res->fetch_assoc()['cnt'] : 0;
}

$tables_result = $conn->query("SHOW TABLES");
$database = $conn->query("SELECT DATABASE()")->fetch_row()[0];
$table_info = [];
while($row = $tables_result->fetch_array()){
    $count = 0;
    $count_res = $conn->query("SELECT COUNT(*) as cnt FROM `$row[0]`");
    if($count_res) $count = $count_res->fetch_assoc()['cnt'];
    $table_info[$row[0]] = $count;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة المدير - إحصائيات</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_dashboard.php" class="btn btn-info">
            <span class="btn-icon">🏪</span>
            إدارة المتاجر
        </a>
        <a href="manage_users.php" class="btn btn-info">
            <span class="btn-icon">👥</span>
            إدارة المستخدمين
        </a>
        <a href="agent_financials.php" class="btn btn-success">
            <span class="btn-icon">💰</span>
            حسابات المندوبين
        </a>
    <a href="manage_guest_products.php" class="btn btn-info">
        <span class="btn-icon">📦</span>
    اعلانات المستخدمين 
    </a>
    
  <a href="manage_market_requests.php" class="btn btn-info">
    <span class="btn-icon">📦</span>
        دبرلي طلبي
    </a>
    <a href="manage_featured.php" class="btn btn-info">
      ⭐ المتاجر المميزة
    </a> 
   <a href="manage_gift_setting.php" class="btn btn-info">
      ⭐ اعجلةالحظ
   </a>   <a href="manage_notifications.php" class="btn btn-info">
     الاشعارات
   </a>

    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">لوحة المدير - إحصائيات قاعدة البيانات</h2>
</div>

<h3 style="text-align: center; margin: 2rem 0 1rem;">👥 المستخدمين حسب الدور</h3>
<div class="stats-container">
    <?php foreach($user_counts as $role => $count): ?>
        <div class="stat-card <?= $role === 'admin' ? 'danger' : ($role === 'agent' ? 'info' : 'success') ?>">
            <div class="stat-icon"><?= $role === 'admin' ? '👑' : ($role === 'agent' ? '👤' : '👥') ?></div>
            <div class="stat-label"><?= strtoupper($role) ?></div>
            <div class="stat-value"><?= $count ?></div>
        </div>
    <?php endforeach; ?>
</div>

<h3 style="text-align: center; margin: 2rem 0 1rem;">🏬 المتاجر حسب المستوى ونوع الاشتراك</h3>
<div class="table-wrapper">
    <table>
        <thead>
            <tr>
                <th class="sortable">المستوى</th>
                <th class="sortable">نوع الاشتراك</th>
                <th class="sortable">الحالة</th>
                <th class="sortable">عدد المتاجر</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($store_counts as $s): ?>
            <tr>
                <td><?= htmlspecialchars($s['tier']) ?></td>
                <td><?= htmlspecialchars($s['subscription_type']) ?></td>
                <td>
                    <span class="badge <?= $s['is_active'] ? 'active' : 'inactive' ?>">
                        <?= $s['is_active'] ? 'نشط' : 'متوقف' ?>
                    </span>
                </td>
                <td><?= $s['cnt'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<h3 style="text-align: center; margin: 2rem 0 1rem;">📦 المنتجات</h3>
<div class="stats-container">
    <div class="stat-card info">
        <div class="stat-icon">📦</div>
        <div class="stat-label">إجمالي المنتجات</div>
        <div class="stat-value"><?= $product_count ?></div>
    </div>
</div>

<h3 style="text-align: center; margin: 2rem 0 1rem;">🗄 معلومات عامة عن الجداول</h3>
<div class="table-wrapper">
    <table>
        <thead>
            <tr>
                <th class="sortable">اسم الجدول</th>
                <th class="sortable">عدد الصفوف</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($table_info as $table => $count): ?>
            <tr>
                <td><?= htmlspecialchars($table) ?></td>
                <td><?= $count ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script src="js/main.js"></script>
</body>
</html>