<?php
include "config.php";

if($_SESSION['role'] != 'admin'){
    die("غير مصرح بالدخول");
}

$tiers_data = include __DIR__ . '/tiers_prices.php';
$calculate_price = $tiers_data['calculate_price'];

$today = date('Y-m-d');
$conn->query("
    UPDATE stores 
    SET payment_status = CASE
        WHEN payment_due_date = DATE_ADD('$today', INTERVAL 2 DAY) THEN 'near_expiry_2'
        WHEN payment_due_date = DATE_ADD('$today', INTERVAL 7 DAY) THEN 'near_expiry_7'
        WHEN payment_due_date < '$today' THEN 'expired'
        ELSE payment_status
    END
");

if(isset($_POST['toggle_store_id'])){
    $store_id = intval($_POST['toggle_store_id']);
    $stmt = $conn->prepare("SELECT is_active FROM stores WHERE id=?");
    $stmt->bind_param("i", $store_id);
    $stmt->execute();
    $store = $stmt->get_result()->fetch_assoc();

    if($store){
        if($store['is_active']){
            $conn->query("UPDATE stores SET is_active=0 WHERE id=$store_id");
            $conn->query("UPDATE products SET is_active=0 WHERE store_id=$store_id");
        } else {
            $conn->query("UPDATE stores SET is_active=1 WHERE id=$store_id");
            $conn->query("UPDATE products SET is_active=1 WHERE store_id=$store_id");
        }
    }
}

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['store_id'])){
    $store_id = intval($_POST['store_id']);
    $subscription_type = $_POST['subscription_type'];
    $new_tier = $_POST['new_tier'];

    $payment_amount = $calculate_price($new_tier, $subscription_type);

    if($subscription_type === 'monthly'){
        $payment_due_date = date('Y-m-d', strtotime('+1 month'));
    } elseif($subscription_type === 'semi-annual'){
        $payment_due_date = date('Y-m-d', strtotime('+6 months'));
    } else {
        $payment_due_date = date('Y-m-d', strtotime('+1 year'));
    }

    $stmt = $conn->prepare("
        UPDATE stores 
        SET payment_status='paid',
            last_payment_amount=?,
            last_payment_date=NOW(),
            payment_due_date=?,
            subscription_type=?,
            tier=?
        WHERE id=?
    ");
    $stmt->bind_param("dsssi", $payment_amount, $payment_due_date, $subscription_type, $new_tier, $store_id);
    $stmt->execute();

    $stmt2 = $conn->prepare("
        INSERT INTO agent_collections 
        (agent_id, store_id, amount, tier, subscription_type)
        SELECT agent_id, id, ?, ?, ?
        FROM stores WHERE id = ?
    ");
    $stmt2->bind_param("dssi", $payment_amount, $new_tier, $subscription_type, $store_id);
    $stmt2->execute();
}

$result = $conn->query("
    SELECT * 
    FROM stores 
    ORDER BY is_active DESC, id DESC
");
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة المدير</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="nav-bar">
    <div class="nav-links">
        <a href="admin_stats.php" class="btn btn-home">
            <span class="btn-icon">🏠</span>
            الرئيسية
        </a>
        <a href="manage_users.php" class="btn btn-info">
            <span class="btn-icon">👥</span>
            إدارة المستخدمين
        </a>
        <a href="agent_financials.php" class="btn btn-success">
            <span class="btn-icon">💰</span>
            حسابات المندوبين
        </a>
    </div>
    <a href="logout.php" class="btn btn-logout">
        <span class="btn-icon">🚪</span>
        تسجيل الخروج
    </a>
</div>

<div class="page-header">
    <h2 class="page-title">لوحة المدير - كل المتاجر</h2>
</div>

<?php if(isset($message)): ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<div class="table-wrapper">
    <div class="table-controls">
        <div class="search-box">
            <input type="text" id="tableSearch" 
                   placeholder="🔍 ابحث (اسم المتجر، المحافظة، المندوب، المستوى...)">
        </div>
        <div class="filter-controls">
            <select class="filter-select" data-column="حالة الدفع">
                <option value="all">جميع حالات الدفع</option>
                <option value="paid">مدفوع</option>
                <option value="expired">منتهي</option>
                <option value="near_expiry">قريب الانتهاء</option>
            </select>
            <select class="filter-select" data-column="حالة المتجر">
                <option value="all">جميع الحالات</option>
                <option value="مفعل">مفعل</option>
                <option value="متوقف">متوقف</option>
            </select>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th class="sortable">#</th>
                <th class="sortable">الاسم</th>
                <th class="sortable">المحافظة</th>
                <th class="sortable">حالة المتجر</th>
                <th class="sortable">حالة الدفع</th>
                <th class="sortable">المستوى</th>
                <th class="sortable">المندوب</th>
                <th class="sortable">انتهاء الاشتراك</th>
                <th class="sortable">نوع الاشتراك</th>
                <th class="sortable">آخر دفعة</th>
                <th>إدارة</th>
            </tr>
        </thead>
        <tbody>
            <?php while($store = $result->fetch_assoc()): ?>
            <tr>
                <td><?= $store['id'] ?></td>
                <td><?= htmlspecialchars($store['name']) ?></td>
                <td><?= htmlspecialchars($store['governorate']) ?></td>
                <td>
                    <span class="badge <?= $store['is_active'] ? 'active' : 'inactive' ?>">
                        <?= $store['is_active'] ? 'مفعل' : 'متوقف' ?>
                    </span>
                </td>
                <td>
                    <span class="badge <?= $store['payment_status'] ?>">
                        <?= $store['payment_status'] ?>
                    </span>
                </td>
                <td><?= htmlspecialchars($store['tier']) ?></td>
                <td><?= htmlspecialchars($store['agent_id']) ?></td>
                <td><?= htmlspecialchars($store['payment_due_date']) ?></td>
                <td><?= htmlspecialchars($store['subscription_type']) ?></td>
                <td><?= number_format($store['last_payment_amount'], 2) ?> $</td>
                <td>
                    <form method="post" style="margin-bottom: 0.5rem;">
                        <input type="hidden" name="toggle_store_id" value="<?= $store['id'] ?>">
                        <button type="submit" class="btn <?= $store['is_active'] ? 'btn-warning' : 'btn-success' ?>">
                            <?= $store['is_active'] ? '⏸ إيقاف' : '▶ إعادة تفعيل' ?>
                        </button>
                    </form>

                    <form method="post" class="payment-form">
                        <input type="hidden" name="store_id" value="<?= $store['id'] ?>">
                        <select name="subscription_type" class="subscription_type">
                            <option value="monthly" <?= $store['subscription_type']=='monthly'?'selected':'' ?>>شهري</option>
                            <option value="semi-annual" <?= $store['subscription_type']=='semi-annual'?'selected':'' ?>>نصف سنوي</option>
                            <option value="yearly" <?= $store['subscription_type']=='yearly'?'selected':'' ?>>سنوي</option>
                        </select>
                        <select name="new_tier" class="new_tier">
                            <?php 
                            $tiers = ['FREE','SILVER','GOLD','PLATINUM','DIMOUND','VIP'];
                            foreach($tiers as $tier){
                                $selected = ($tier == $store['tier']) ? 'selected' : '';
                                echo "<option value='$tier' $selected>$tier</option>";
                            }
                            ?>
                        </select>
                        <p style="margin: 0.5rem 0; font-size: 0.9rem;">المبلغ: <span class="calculated_amount">0.00</span> $</p>
                        <button type="submit" class="btn btn-primary">💳 دفع وحفظ</button>
                    </form>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<script>
const tiers = <?= json_encode($tiers_data['tiers']) ?>;
const discounts = <?= json_encode($tiers_data['discounts']) ?>;
window.tiers = tiers;
window.discounts = discounts;
</script>
<script src="js/main.js"></script>

</body>
</html>