<?php
header('Content-Type: application/json; charset=utf-8');
include 'db.php';

// جلب آخر سجل من جدول app_settings
$result = $conn->query("SELECT * FROM app_settings ORDER BY id DESC LIMIT 1");

if ($result && $result->num_rows > 0) {
    $data = $result->fetch_assoc();
    
    echo json_encode([
        'status' => 'success',
        'force_update' => (bool)$data['force_update'],
        'latest_version' => $data['latest_version'],
        'update_url' => $data['update_url'],
        'maintenance_mode' => (bool)$data['maintenance_mode'],
        'maintenance_message' => $data['maintenance_message']
    ], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'لم يتم العثور على إعدادات التطبيق.'
    ], JSON_UNESCAPED_UNICODE);
}

$conn->close();
?>
