<?php
require_once __DIR__ . '/vendor/autoload.php'; // مكتبة JWT
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$key = "d%o9r@aidr%a9m@aw%r1d@s%o11l@en%%"; // مفتاح التوقيع

/**
 * دالة للتحقق من التوكن وإرجاع user_id
 */
function authenticate() {
    global $key;

    // جلب جميع الهيدرز بطريقة موثوقة
    $headers = function_exists('getallheaders') ? getallheaders() : [];
    $authHeader = null;

    foreach ($headers as $keyName => $value) {
        if (strtolower($keyName) === 'authorization') {
            $authHeader = $value;
            break;
        }
    }

    if (!$authHeader) {
        // بعض الخوادم تضعه في $_SERVER
        if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
            $authHeader = $_SERVER['HTTP_AUTHORIZATION'];
        } elseif (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
            $authHeader = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
        }
    }

    if (!$authHeader) {
        http_response_code(401);
        echo json_encode(["status" => "error", "message" => "Missing Authorization header"]);
        exit();
    }

    // تحقق من صيغة Bearer Token
    if (!preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        http_response_code(401);
        echo json_encode(["status" => "error", "message" => "Invalid Authorization header"]);
        exit();
    }

    $jwt = $matches[1];

    try {
        // فك التوقيع والتحقق
        $decoded = JWT::decode($jwt, new Key($key, 'HS256'));

        if (!isset($decoded->data->user_id)) {
            throw new Exception("Token payload missing user_id");
        }

        return intval($decoded->data->user_id);

    } catch (Exception $e) {
        http_response_code(401);
        echo json_encode([
            "status" => "error",
            "message" => "Invalid or expired token",
            "error" => $e->getMessage()
        ]);
        exit();
    }
}
?>
