<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/auth.php';
include 'db.php';

$userId = authenticate();
$data = json_decode(file_get_contents("php://input"));

if (!empty($data->store_id) && !empty($data->name) && !empty($data->category)) {
    $store_id = intval($data->store_id);
    $name = htmlspecialchars(strip_tags($data->name));
    $category = strtolower($data->category);
    $description = !empty($data->description) ? htmlspecialchars(strip_tags($data->description)) : "";
    $image_url = !empty($data->image_url) ? htmlspecialchars(strip_tags($data->image_url)) : "";

    // جميع الحقول الجديدة
    $company = !empty($data->company) ? htmlspecialchars(strip_tags($data->company)) : null;
    $model = !empty($data->model) ? htmlspecialchars(strip_tags($data->model)) : null;
    $processor = !empty($data->processor) ? htmlspecialchars(strip_tags($data->processor)) : null;
    $ram = !empty($data->ram) ? htmlspecialchars(strip_tags($data->ram)) : null;
    $storage = !empty($data->storage) ? htmlspecialchars(strip_tags($data->storage)) : null;
    $gpu = !empty($data->gpu) ? htmlspecialchars(strip_tags($data->gpu)) : null;
    $battery = !empty($data->battery) ? htmlspecialchars(strip_tags($data->battery)) : null;
    $price = isset($data->price) ? floatval($data->price) : null;

    $os = !empty($data->os) ? htmlspecialchars(strip_tags($data->os)) : null;
    $screen_size = !empty($data->screen_size) ? htmlspecialchars(strip_tags($data->screen_size)) : null;
    $screen_resolution = !empty($data->screen_resolution) ? htmlspecialchars(strip_tags($data->screen_resolution)) : null;
    $front_camera = !empty($data->front_camera) ? htmlspecialchars(strip_tags($data->front_camera)) : null;
    $back_camera = !empty($data->back_camera) ? htmlspecialchars(strip_tags($data->back_camera)) : null;
    $cpu_generation = !empty($data->cpu_generation) ? htmlspecialchars(strip_tags($data->cpu_generation)) : null;
    $cpu_speed = !empty($data->cpu_speed) ? htmlspecialchars(strip_tags($data->cpu_speed)) : null;
    $cpu_cores = !empty($data->cpu_cores) ? htmlspecialchars(strip_tags($data->cpu_cores)) : null;
    $ram_type = !empty($data->ram_type) ? htmlspecialchars(strip_tags($data->ram_type)) : null;
    $storage_type = !empty($data->storage_type) ? htmlspecialchars(strip_tags($data->storage_type)) : null;
    $network_support = !empty($data->network_support) ? htmlspecialchars(strip_tags($data->network_support)) : null;
    $weight = !empty($data->weight) ? htmlspecialchars(strip_tags($data->weight)) : null;
    $dimensions = !empty($data->dimensions) ? htmlspecialchars(strip_tags($data->dimensions)) : null;

    // تحقق من صحة الفئة
    if (!in_array($category, ['laptop', 'mobile', 'technology'])) {
        echo json_encode(["status" => "error", "message" => "الفئة غير صحيحة، يجب أن تكون laptop أو mobile أو technology."]);
        exit;
    }

    // التحقق من ملكية المتجر
    $ownershipQuery = "SELECT tier FROM stores WHERE id = ? AND user_id = ?";
    $stmtOwnership = $conn->prepare($ownershipQuery);
    $stmtOwnership->bind_param("ii", $store_id, $userId);
    $stmtOwnership->execute();
    $stmtOwnership->bind_result($storeTier);
    $hasStore = $stmtOwnership->fetch();
    $stmtOwnership->close();

    if (!$hasStore) {
        echo json_encode(["status" => "error", "message" => "المتجر غير موجود أو ليس لديك صلاحية لإضافة منتجات إليه."]);
        exit;
    }

    $tier = strtolower($storeTier);
    $limits = ['free'=>3,'silver'=>5,'gold'=>7,'platinum'=>10,'diamond'=>15,'vip'=>30];
    $maxProducts = $limits[$tier] ?? 3;

    // عدّ المنتجات الحالية للمتجر
    $countQuery = "SELECT COUNT(*) AS total FROM products WHERE store_id = ?";
    $stmtCount = $conn->prepare($countQuery);
    $stmtCount->bind_param("i", $store_id);
    $stmtCount->execute();
    $stmtCount->bind_result($currentCount);
    $stmtCount->fetch();
    $stmtCount->close();
    $currentCount = intval($currentCount);

    if ($currentCount >= $maxProducts) {
        echo json_encode(["status" => "error", "message" => "وصلت إلى الحد الأقصى لعدد المنتجات المسموح به لهذا المستوى ($tier)."]);
        exit;
    }

    // إضافة المنتج بجميع الحقول
    $query = "INSERT INTO products 
    (store_id,name,category,description,image_url,company,model,processor,ram,storage,gpu,battery,price,
    os,screen_size,screen_resolution,front_camera,back_camera,cpu_generation,cpu_speed,cpu_cores,
    ram_type,storage_type,network_support,weight,dimensions)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    $stmt = $conn->prepare($query);
$stmt->bind_param(
    "isssssssssssdsssssssssssss", // لاحظ زيادة حرف 's' بدل 'i' ل cpu_cores
    $store_id,$name,$category,$description,$image_url,
    $company,$model,$processor,$ram,$storage,$gpu,$battery,$price,
    $os,$screen_size,$screen_resolution,$front_camera,$back_camera,$cpu_generation,$cpu_speed,$cpu_cores,
    $ram_type,$storage_type,$network_support,$weight,$dimensions
);


    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "تم إضافة المنتج بنجاح."]);
    } else {
        echo json_encode(["status" => "error", "message" => "فشل في إضافة المنتج: ".$stmt->error]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "الرجاء ملء جميع الحقول المطلوبة."]);
}
?>
