<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

$user_id = authenticate(); // جلب المستخدم المسجل
$data = json_decode(file_get_contents("php://input"), true);

$type = $data['type'] ?? '';
$part_name = trim($data['part_name'] ?? '');
$contact_phone = trim($data['contact_phone'] ?? '');
$governorate = trim($data['governorate'] ?? ''); // ✅ إضافة الحقل

// التحقق من القيم
if (!in_array($type, ['request','offer'])) {
    echo json_encode(["success" => false, "message" => "نوع غير صحيح"]);
    exit;
}

if ($part_name === '' || $contact_phone === '' || $governorate === '') {
    echo json_encode(["success" => false, "message" => "البيانات ناقصة"]);
    exit;
}

// إدخال البيانات مع المحافظة
$stmt = $conn->prepare("
    INSERT INTO market_requests (type, part_name, contact_phone, governorate, user_id, is_active)
    VALUES (?, ?, ?, ?, ?, 0)
");

$stmt->bind_param("ssssi", $type, $part_name, $contact_phone, $governorate, $user_id);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "تم إرسال الطلب وهو قيد المراجعة"
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "فشل حفظ الطلب"
    ]);
}
